﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using PI.FM.N000.Base.WinForms.Controls;

namespace PI.ZB.N1200.ELearning.WinForms.CompetencePart
{
    public partial class UCTabCompetencePartDetails : PI.FM.N000.Base.WinForms.Controls.TabPageContainerControl
    {
        private static Gemini.Utility.Collections.Dictionary<PI.ZB.N1200.ELearning.BL.BO.View.Competence> _CompetenceDictionary = null;

        public UCTabCompetencePartDetails()
        {
            InitializeComponent();
            Dock = DockStyle.Fill;
        }

        protected UCCompetencePartDetails UCDetails
        {
            get { return (UCCompetencePartDetails)base.UCBODetails; }
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            
            UCDetails.DataManager.Bindings.Add(_gTextBoxTitle, "Name", _gLabelTitle);
            UCDetails.DataManager.Bindings.Add(_gTextBoxAbbreviation, "Abbreviation", _gLabelAbbreviation);
            UCDetails.DataManager.Bindings.Add(_gCheckBoxIsActive, "IsActive");

            _gftpControlImage.Initialize(UCDetails.Environment, UCDetails.Plugin, true);
            _gftpControlImage.FileFilter = Gemini.Dictionary.FileFilters.Picture;
            _gftpControlImage.OnFileChanged += new CM.N214.FTP.WinForms.GFTPControl.FileChangedEventHandler(ImageChanged);
            _gPictureBox.LoadCompleted += new AsyncCompletedEventHandler(ImageLoadCompleted);
        }

        void ImageLoadCompleted(object sender, AsyncCompletedEventArgs e)
        {
            _gPictureBox.Visible = true;

        }

        void ImageChanged()
        {
            if (_gftpControlImage.IsFileExist)
            {
                _gPictureBox.Visible = false;
                _gPictureBox.LoadAsync(_gftpControlImage.URL);
            }
            else
            {
                _gPictureBox.Visible = false;
            }
        }

        public override void DoRestore()
        {
            _gTextBoxCompetence.Text = string.Empty;
            if (UCDetails.DataManager.Current != null)
            {
                _gftpControlImage.ID = UCDetails.DataManager.Current.ImageFileID;
                if (!String.IsNullOrEmpty(UCDetails.DataManager.Current.ImageFileURL))
                {
                    _gPictureBox.Visible = false;
                    _gPictureBox.LoadAsync(UCDetails.DataManager.Current.ImageFileURL);
                }
                else
                {
                    _gPictureBox.Visible = false;
                }

                _gTextBoxCompetence.Text = GetCompetence();
            }
        }

        public override bool DoSave()
        {
            if (UCDetails.DataManager.Current != null)
            {
                if (_gftpControlImage.IsFileExist)
                {
                    UCDetails.DataManager.Current.ImageFileID = _gftpControlImage.ID;
                    UCDetails.DataManager.Current.ImageFileURL = _gftpControlImage.URL;
                }
                else
                {
                    UCDetails.DataManager.Current.ImageFileID = null;
                    UCDetails.DataManager.Current.ImageFileURL = null;
                }
            }
            return true;
        }

        protected string GetCompetence()
        {
            if ((UCDetails.DataManager.Current != null && UCDetails.DataManager.Current.CompetenceID.HasValue))
            {
                if (_CompetenceDictionary == null)
                {

                    _CompetenceDictionary = new Gemini.Utility.Collections.Dictionary<PI.ZB.N1200.ELearning.BL.BO.View.Competence>(UCDetails.BLZSBELearning.Competence.View.Restore(),
                        new Gemini.Utility.Collections.Dictionary<PI.ZB.N1200.ELearning.BL.BO.View.Competence>.RestoreById(UCDetails.BLZSBELearning.Competence.View.Restore));
                }

                if (_CompetenceDictionary.Restore(UCDetails.DataManager.Current.CompetenceID.Value) != null)
                {
                    return _CompetenceDictionary.Restore(UCDetails.DataManager.Current.CompetenceID.Value).Name;
                }
                else
                {
                    return String.Empty;
                }
            }
            else
            {
                return String.Empty;
            }
        }
    }
}
